﻿using System;
using System.Linq;
using EfCoreMigration.Data;
using EfCoreMigration.Models;

namespace EfCoreMigration
{
    class Program
    {
        static void Main(string[] args)
        {
            Opslaan();
            Opvragen();
            //Opvragen(3);
            //Bijwerken(3, "M.A.C. de Rond");
            Koppelen();
        }


        static void Koppelen()
        {
            using (var db = new SportContext())
            {
                var evenement = new Evenement
                {
                    Naam = "USATF Masters Championships indoor",
                    Plaats = "Landover, USA",
                    Afstand = 800,
                    Datum = new DateTime(2018, 3, 18)
                };
                db.Add(evenement);
                var atleet = db.Atleten.First();

                db.Add(new Deelname
                {
                    Evenement = evenement,
                    Atleet = atleet,
                    Tijd = new TimeSpan(0,0,9,56,440)
                });
                db.SaveChanges();
            }
        }

        static void Opslaan()
        {
            using (var db = new SportContext())
            {
                // Een enkel object
                Console.WriteLine("Voeg een atleet toe.");
                db.Add(new Atleet { Naam = "Orville Curtis Rogers", Nationaliteit = "US", Geboortedatum = new DateTime(1917, 11, 28) });
                db.SaveChanges();

                Console.WriteLine("Voeg twee atleten in een keer toe.");
                // Meerdere objecten
                db.Add(new Atleet { Naam = "Michiel de Rond", Nationaliteit = "NL", Geboortedatum = new DateTime(1973, 4, 12) });
                db.Add(new Atleet { Naam = "Melita de Rond", Nationaliteit = "NL", Geboortedatum = new DateTime(2001, 9, 7) });
                db.SaveChanges();
            }
        }

        static void Opvragen()
        {
            using (var db = new SportContext())
            {
                var atleet = db.Atleten.First();
                Console.WriteLine($"De eerste atleet in de database: {atleet.Naam}");

                Console.WriteLine("Alle atleten in de database:");
                var atleten = db.Atleten.ToList();
                foreach (var a in atleten)
                {
                    Console.WriteLine($" {a.Id}: {a.Naam}");
                }
            }
        }

        static void Opvragen(int id)
        {
            using (var db = new SportContext())
            {
                var atleet = db.Atleten.Where(a => a.Id == id).FirstOrDefault();
                if (atleet == null)
                {
                    Console.WriteLine($"Er is geen atleet met id {id}");
                }
                else
                {
                    Console.WriteLine($"De atleet met id {id} is {atleet.Naam}");
                }
            }
        }

        static void Bijwerken(int id, string naam)
        {
            using (var db = new SportContext())
            {
                var atleet = db.Atleten.Where(a => a.Id == id).FirstOrDefault();
                if (atleet == null)
                {
                    Console.WriteLine($"Er is geen atleet met id {id}");
                }
                else
                {
                    atleet.Naam = naam;
                    db.SaveChanges();
                    Console.WriteLine($"De atleet met id {id} heet nu {atleet.Naam}");
                }
            }
        }
    }
}
