﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

namespace EfCoreMigration.Migrations
{
    public partial class DeelnamesToegevoegd : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "Evenementen",
                columns: table => new
                {
                    ID = table.Column<int>(nullable: false)
                        .Annotation("Sqlite:Autoincrement", true),
                    Naam = table.Column<string>(nullable: false),
                    Plaats = table.Column<string>(nullable: false),
                    Afstand = table.Column<int>(nullable: false),
                    Datum = table.Column<DateTime>(nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Evenementen", x => x.ID);
                });

            migrationBuilder.CreateTable(
                name: "Deelname",
                columns: table => new
                {
                    ID = table.Column<int>(nullable: false)
                        .Annotation("Sqlite:Autoincrement", true),
                    AtleetId = table.Column<int>(nullable: false),
                    EvenementId = table.Column<int>(nullable: false),
                    Tijd = table.Column<TimeSpan>(nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Deelname", x => x.ID);
                    table.ForeignKey(
                        name: "FK_Deelname_Atleten_AtleetId",
                        column: x => x.AtleetId,
                        principalTable: "Atleten",
                        principalColumn: "ID",
                        onDelete: ReferentialAction.Cascade);
                    table.ForeignKey(
                        name: "FK_Deelname_Evenementen_EvenementId",
                        column: x => x.EvenementId,
                        principalTable: "Evenementen",
                        principalColumn: "ID",
                        onDelete: ReferentialAction.Cascade);
                });

            migrationBuilder.CreateIndex(
                name: "IX_Deelname_AtleetId",
                table: "Deelname",
                column: "AtleetId");

            migrationBuilder.CreateIndex(
                name: "IX_Deelname_EvenementId",
                table: "Deelname",
                column: "EvenementId");
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "Deelname");

            migrationBuilder.DropTable(
                name: "Evenementen");
        }
    }
}
