﻿using System;
using System.Net.Http;
using System.Text;
using System.Text.Json;
using System.Threading.Tasks;
using SportWebApiClient.Models;

namespace SportWebApiClient
{
    class Program
    {
        static async Task Main(string[] args)
        {
            await PostDataAsync();
        }

        private static async Task PostDataAsync()
        {
            Atleet michiel = new Atleet() { Naam = "Michiel de Rond", 
                                            Geboortedatum = new DateTime(1973,4,12), 
                                            Nationaliteit = "Nederlands" };
            string json = JsonSerializer.Serialize(michiel, typeof(Atleet));

            HttpClient httpClient = new HttpClient();
            var httpContent = new StringContent(json, Encoding.Default, "application/json");
            var response = await httpClient.PostAsync("https://localhost:5001/api/atleten/", httpContent);

            response.EnsureSuccessStatusCode();

            string content = await response.Content.ReadAsStringAsync();

            var options = new JsonSerializerOptions();
            options.PropertyNameCaseInsensitive = true;
            options.PropertyNamingPolicy = JsonNamingPolicy.CamelCase;

            var atleet = JsonSerializer.Deserialize<Atleet>(content, options);

            Console.WriteLine($"{atleet.Naam} ({atleet.Nationaliteit})");
        }
    }
}
