using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using SportWebApi.Models;

namespace SportWebApi.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class AtletenController : ControllerBase
    {
        private readonly SportContext _context;

        public AtletenController(SportContext context)
        {
            _context = context;
        }

        // GET: api/Atleten
        [HttpGet]
        public async Task<ActionResult<IEnumerable<Atleet>>> GetAtleet()
        {
            return await _context.Atleet.ToListAsync();
        }

        // GET: api/Atleten/5
        [HttpGet("{id}")]
        public async Task<ActionResult<Atleet>> GetAtleet(int id)
        {
            var atleet = await _context.Atleet.FindAsync(id);

            if (atleet == null)
            {
                return NotFound();
            }

            return atleet;
        }

        // PUT: api/Atleten/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for
        // more details see https://aka.ms/RazorPagesCRUD.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutAtleet(int id, Atleet atleet)
        {
            if (id != atleet.ID)
            {
                return BadRequest();
            }

            _context.Entry(atleet).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!AtleetExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/Atleten
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for
        // more details see https://aka.ms/RazorPagesCRUD.
        [HttpPost]
        public async Task<ActionResult<Atleet>> PostAtleet(Atleet atleet)
        {
            _context.Atleet.Add(atleet);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetAtleet", new { id = atleet.ID }, atleet);
        }

        // DELETE: api/Atleten/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<Atleet>> DeleteAtleet(int id)
        {
            var atleet = await _context.Atleet.FindAsync(id);
            if (atleet == null)
            {
                return NotFound();
            }

            _context.Atleet.Remove(atleet);
            await _context.SaveChangesAsync();

            return atleet;
        }

        private bool AtleetExists(int id)
        {
            return _context.Atleet.Any(e => e.ID == id);
        }
    }
}
