using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using MvcSport.Data;
using MvcSport.Models;

namespace MvcSport.Controllers
{
    public class AtletenController : Controller
    {
        private readonly MvcSportContext _context;

        public AtletenController(MvcSportContext context)
        {
            _context = context;
        }

        // GET: Atleten
        public async Task<IActionResult> Index()
        {
            return View("Index", await _context.Atleet.ToListAsync());
        }

        // GET: Atleten/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                ViewData["Melding"] = "Er is geen atleet gevonden; maak een nieuwe aan.";
                return View("Create");
                //return NotFound();
            }

            var atleet = await _context.Atleet
                .FirstOrDefaultAsync(m => m.ID == id);
            if (atleet == null)
            {
                return NotFound();
            }

            return View(atleet);
        }

        // GET: Atleten/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: Atleten/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("ID,Naam,Geboortedatum,Nationaliteit")] Atleet atleet)
        {
            if (ModelState.IsValid)
            {
                _context.Add(atleet);
                await _context.SaveChangesAsync();
                return RedirectToAction(nameof(Index));
            }
            return View(atleet);
        }

        // GET: Atleten/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var atleet = await _context.Atleet.FindAsync(id);
            if (atleet == null)
            {
                return NotFound();
            }
            return View(atleet);
        }

        // POST: Atleten/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("ID,Naam,Geboortedatum,Nationaliteit")] Atleet atleet)
        {
            if (id != atleet.ID)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(atleet);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!AtleetExists(atleet.ID))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction(nameof(Index));
            }
            return View(atleet);
        }

        // GET: Atleten/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var atleet = await _context.Atleet
                .FirstOrDefaultAsync(m => m.ID == id);
            if (atleet == null)
            {
                return NotFound();
            }

            return View(atleet);
        }

        // POST: Atleten/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var atleet = await _context.Atleet.FindAsync(id);
            _context.Atleet.Remove(atleet);
            await _context.SaveChangesAsync();
            return RedirectToAction(nameof(Index));
        }

        private bool AtleetExists(int id)
        {
            return _context.Atleet.Any(e => e.ID == id);
        }
    }
}
