using Microsoft.AspNetCore.Razor.TagHelpers;

namespace Formulieren.TagHelpers
{
    [HtmlTargetElement(Attributes = "Condition")]
    public class ConditionTagHelper : TagHelper
    {
        public bool Condition { get; set; }

        public override void Process(TagHelperContext context, TagHelperOutput output)
        {
            if (!Condition)
            {
                output.SuppressOutput();
            }
        }
    }
}