using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.AspNetCore.Mvc.Rendering;

namespace Formulieren.Pages
{
    public enum Niveaus
    {
        Beginner,
        Halfgevorderd,
        Gevorderd
    }

    public class ProeflesModel : PageModel
    {
        [BindProperty]
        [Required(ErrorMessage = "Dit veld is verplicht")]
        [MinLength(4, ErrorMessage = "De ingevoerde waarde is niet lang genoeg")]
        [Display(Name = "Naam",
                 Prompt = "Uw volledige naam",
                 Description = "Voer uw volledige naam in")]
        public string Naam { get; set; }

        [BindProperty]
        [Required(ErrorMessage = "Dit veld is verplicht")]
        [DataType(DataType.EmailAddress)]
        [Display(Name = "E-mailadres",
                 Prompt = "Uw e-mailadres",
                 Description = "Voer uw e-mailadres in")]
        public string EmailAdres { get; set; }

        [BindProperty]
        [DataType(DataType.PhoneNumber)]
        [Display(Name = "Telefoonnummer",
                 Prompt = "Een telefoonnummer waarop u goed bereikbaar bent",
                 Description = "Voer uw telefoonnummer in")]
        public string Telefoonnummer { get; set; }

        /*
                [BindProperty]
                [Required(ErrorMessage = "Dit veld is verplicht")]
                [Display(Name = "Ervaring",
                         Prompt = "Geef aan hoeveel uur in per week momenteel traint",
                         Description = "Hoeveel traint u momenteel?")]
                public string Ervaring { get; set; }
                public List<SelectListItem> Options { get; set; }
        */

        [BindProperty]
        [Required(ErrorMessage = "Dit veld is verplicht")]
        [Display(Name = "Niveau")]
        public Niveaus? Niveau { get; set; }

        [BindProperty]
        [Required(ErrorMessage = "Dit veld is verplicht")]
        [Display(Name = "Hoe vaak wilt u trainen?")]
        public string Frequentie { get; set; }
        public string[] Frequenties = new[] { "Eenmaal", "Tweemaal", "Driemaal" };

        [BindProperty]
        [DataType(DataType.Date)]
        [Display(Name = "Voorkeursdatum",
                 Description = "Voer uw voorkeursdatum voor de proefles in")]
        public DateTime VoorkeurDatum { get; set; } = DateTime.Today.AddDays(7);

        [BindProperty]
        [Required(ErrorMessage = "Dit veld is verplicht")]
        [MinLength(10, ErrorMessage = "De ingevoerde waarde is niet lang genoeg")]
        [DataType(DataType.MultilineText)]
        [Display(Name = "Achtergrond",
                 Prompt = "Vertel kort iets over uw trainingsdoelen",
                 Description = "Welke doelen heeft u voor ogen?")]
        public string Beschrijving { get; set; }

        [BindProperty]
        [Display(Name = "Ik ga akkoord met de voorwaarden")]
        [Range(typeof(bool), "true", "true", ErrorMessage = "U kunt alleen een aanvraag doen wanneer u akkoord gaat met de voorwaarden.")]
        public bool Akkoord { get; set; }

        public bool Verwerkt { get; set; } = false;
        public bool ToonFormulier => !Verwerkt;

        [BindProperty]
        [DataType(DataType.Upload)]
        [Display(Name = "Foto")]
        public IFormFile Foto { get; set; }
        public string FotoBestand { get; set; }
        private IWebHostEnvironment _webHostEnvironment;

        public ProeflesModel(IWebHostEnvironment webHostEnvironment)
        {
            _webHostEnvironment = webHostEnvironment;
        }

        public void OnGet()
        {
            /*
                        Options = new List<SelectListItem> {
                                              new SelectListItem
                                              {
                                                  Value = "beginner",
                                                  Text =  "Beginner: ik loop nu niet, of maximaal een half uur in de week"
                                              },
                                              new SelectListItem
                                              {
                                                  Value = "halfgevorderd",
                                                  Text =  "Halfgevorderd: ik loop een tot drie keer per week"
                                              },
                                              new SelectListItem
                                              {
                                                  Value = "gevorderd",
                                                  Text =  "Gevorderd: ik loop drie keer per week of vaker minimaal een half uur per keer"
                                              }  };
            */
        }

        public void OnPost()
        {
            if (!ModelState.IsValid)
            {
                ViewData["Message"] = ModelState.ErrorCount;
                Verwerkt = false;
            }
            else
            {
                // verwerk het formulier hier
                FotoBestand = Path.GetRandomFileName();
                var bestand = Path.Combine(_webHostEnvironment.ContentRootPath, "Uploads", FotoBestand);
                using (var fileStream = new FileStream(bestand, FileMode.Create))
                {
                    Foto.CopyTo(fileStream);
                }

                Verwerkt = true;
            }
        }
    }
}