using System.Threading.Tasks;
using Microsoft.AspNetCore.Razor.TagHelpers;

//[HtmlTargetElement("Twitter-Account")]
[HtmlTargetElement(Attributes = "twitter")]
//[HtmlTargetElement("Twitter-Account", Attributes = "Twitter, SameWindow")]
public class TwitterAccountTagHelper : TagHelper
{
    [HtmlAttributeName("reuse-window")]
    public bool SameWindow { get; set; } = false;

    public override async Task ProcessAsync(TagHelperContext context, TagHelperOutput output)
    {
        var content = await output.GetChildContentAsync();
        var username = content.GetContent();
        string account = $"@{username}";

        output.TagName = "a";
        output.Attributes.RemoveAll("twitter");
        output.Attributes.SetAttribute("href", "https://twitter.com/" + account);
        if(!SameWindow)
        {
            output.Attributes.SetAttribute("target", "_blank");
        }
        output.Content.SetContent(account);
    }
}