using System;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Razor.TagHelpers;

[HtmlTargetElement(Attributes = "list")]
public class ListTagHelper : TagHelper
{
    public override async Task ProcessAsync(TagHelperContext context, TagHelperOutput output)
    {
        var content = await output.GetChildContentAsync();
        var regels = content.GetContent();
        StringBuilder stringBuilder = new StringBuilder();
        foreach (var regel in regels.Split(new char[] { '\n', '\r' }, StringSplitOptions.RemoveEmptyEntries))
        {
            stringBuilder.AppendLine($"<li>{regel}</li>");
        }

        output.Attributes.RemoveAll("list");
        output.PreContent.SetHtmlContent("<ul>");
        output.Content.SetHtmlContent(stringBuilder.ToString());
        output.PostContent.SetHtmlContent("</ul>");
    }
}