using Microsoft.AspNetCore.Razor.TagHelpers;
using TagHelpers.Models;

[HtmlTargetElement(Attributes = "email")]
public class EmailTagHelper : TagHelper
{
    public Gebruiker gebruiker { get; set; }
    public override void Process(TagHelperContext context, TagHelperOutput output)
    {
        output.TagName = "a";
        output.Attributes.RemoveAll("email");
        output.Attributes.SetAttribute("href", "mailto:" + gebruiker.EmailAdres);
        output.Content.SetContent($"{gebruiker.Naam}");
    }
}