using System;

namespace SportModel
{
    public class Sporter : Persoon
    {
        private float _gewicht;

        public float Gewicht
        {
            get
            {
                return _gewicht;
            }
            set
            {
                if (value > 0)
                {
                    _gewicht = value;
                }

            }
        }

        public string WedstrijdNaam => $"{Naam} ({_geslacht.ToString().Substring(0, 1)}{Leeftijd})";

        public int Belastbaarheid { get; set; }

        public Sporter(string naam, DateTime geboorteDatum, Geslacht geslacht, float gewicht, int belastbaarheid) : base(naam, geboorteDatum, geslacht)
        {
            _gewicht = gewicht;
            Belastbaarheid = belastbaarheid;
        }

        public Sporter(string naam, DateTime geboorteDatum, Geslacht geslacht) : base(naam, geboorteDatum, geslacht)
        {
            Belastbaarheid = 0;
        }

        public virtual void Train()
        {
            Belastbaarheid++;
        }

        public void Wedstrijd()
        {
            Belastbaarheid++;
        }

        public void ZoekHulp(IEhbo reanimator, Persoon slachtoffer)
        {
            reanimator.Reanimeer(slachtoffer);
        }
    }
}
