﻿using System;

namespace SportModel
{
    class Program
    {
        static void Main(string[] args)
        {
            // drie sporters en hun namen
            /*
            Sporter michiel = new Sporter("Michiel", new DateTime(1973, 4, 12), Geslacht.Man);
            Sporter melita = new Sporter("Melita", new DateTime(2001, 9, 7), Geslacht.Vrouw);
            Sporter eliud = new Sporter("Eliud", new DateTime(1984, 11, 5), Geslacht.Man);

            Console.WriteLine(michiel.WedstrijdNaam);
            Console.WriteLine(melita.WedstrijdNaam);
            Console.WriteLine(eliud.WedstrijdNaam);
            */

            Fietser michiel = new Fietser("Michiel", new DateTime(1973, 4, 12), Geslacht.Man);
            Zwemmer melita = new Zwemmer("Melita", new DateTime(2001, 9, 7), Geslacht.Vrouw);
            Hardloper eliud = new Hardloper("Eliud", new DateTime(1984, 11, 5), Geslacht.Man);

            Trainer rob = new Trainer("Rob", default(DateTime), Geslacht.Man);

            michiel.Belastbaarheid = 20;
            melita.Belastbaarheid = 17;
            eliud.Belastbaarheid = 40;

            Console.WriteLine($"Belastbaarheid {michiel.Naam}: {michiel.Belastbaarheid}");
            Console.WriteLine($"Belastbaarheid {melita.Naam}: {melita.Belastbaarheid}");
            Console.WriteLine($"Belastbaarheid {eliud.Naam}: {eliud.Belastbaarheid}");
            for (int t = 0; t < 5; t++)
            {
                rob.Train(michiel);
                rob.Train(melita);
                rob.Train(eliud);
            }

            Console.WriteLine($"Belastbaarheid {michiel.Naam}: {michiel.Belastbaarheid}");
            Console.WriteLine($"Belastbaarheid {melita.Naam}: {melita.Belastbaarheid}");
            Console.WriteLine($"Belastbaarheid {eliud.Naam}: {eliud.Belastbaarheid}");

            // reanimeer michiel!
            eliud.ZoekHulp(rob, michiel);
            
            // stel het huidige wereldrecord (september 2013) in
            Marathon.WereldRecord = new TimeSpan(2, 3, 23);

            // een paar marathons op chronologische volgorde
            Marathon chicago = new Marathon("Chicago 2013", new TimeSpan(2, 3, 45));
            Console.WriteLine($"{chicago.Naam} {chicago.Record} Wereldrecord: {Marathon.WereldRecord}");
            Marathon berlin = new Marathon("Berlin 2018", new TimeSpan(2, 1, 39));
            Console.WriteLine($"{berlin.Naam} {berlin.Record} Wereldrecord: {Marathon.WereldRecord}");
            Marathon amsterdam = new Marathon("Amsterdam 2018", new TimeSpan(2, 4, 6));
            Console.WriteLine($"{amsterdam.Naam} {amsterdam.Record} Wereldrecord: {Marathon.WereldRecord}");
            Marathon rotterdam = new Marathon("Rotterdam 2019", new TimeSpan(2, 4, 11));
            Console.WriteLine($"{rotterdam.Naam} {rotterdam.Record} Wereldrecord: {Marathon.WereldRecord}");

            // test een tijd om te zien of dit een wereldrecord is.
            var tijd = new TimeSpan(1, 59, 40);
            if (Marathon.IsWereldRecord(tijd))
            {
                Console.WriteLine($"Ja, {tijd} is een nieuw wereldrecord!");
            }
            else
            {
                Console.WriteLine($"Nee, {tijd} is geen nieuw wereldrecord...");
            }
        }
    }
}
