using System;

namespace SportModel
{
    public class Persoon
    {
        public string Naam { get; set; }
        protected Geslacht _geslacht;

        public DateTime GeboorteDatum { get; }

        public int Leeftijd
        {
            get
            {
                DateTime vandaag = System.DateTime.Today;
                int leeftijd = vandaag.Year - GeboorteDatum.Year;

                if (vandaag.Month < GeboorteDatum.Month || (vandaag.Month == GeboorteDatum.Month && vandaag.Day < GeboorteDatum.Day))
                {
                    leeftijd--;
                }

                return leeftijd;
            }
        }

        public Persoon(string naam, DateTime geboorteDatum, Geslacht geslacht)
        {
            Naam = naam;
            GeboorteDatum = geboorteDatum;
            _geslacht = geslacht;
        }
    }
}
